package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.enumeration.UserStatusEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.enumeration.ReAssignMessageActionEnum;
import gov.va.med.mhv.sm.model.Annotation;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.PatientBlockedTriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.PatientFacility;
import gov.va.med.mhv.sm.model.NewMessage;
import gov.va.med.mhv.sm.service.FacilityService;
import gov.va.med.mhv.sm.service.PatientBlockedService;
import gov.va.med.mhv.sm.model.PatientBlockedFacility;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.model.ReAssignMessageHistory;
import gov.va.med.mhv.sm.model.PatientReassignFacility;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.util.DateUtils;
import java.util.Collection;
import gov.va.med.mhv.sm.service.UserManagementService;
import org.apache.commons.lang.StringUtils;
import gov.va.med.mhv.sm.service.MessageService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import gov.va.med.mhv.sm.wsclient.IntegrationServiceDelegate;
import gov.va.med.mhv.sm.wsclient.queriessvc.UserLookupResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ReAssignMessage extends ReadMessage {

	private static final long serialVersionUID = 4917561084703445750L;

	private static final Log log = LogFactory.getLog(ReAssignMessage.class);

    private UserManagementService userService;
    private FacilityService facilityService;
	private MessageService messageService;
	private TriageGroupService triageGroupService;
	private PatientBlockedService patientBlockedService;

	private String STRUTS_RESULT;
	private String POPUPWINDOW="POPUPWINDOW";
	private String SELECT_OPTION = "OPTION_SELECT";
	private String MEMBER_SELECT = "MEMBER_SELECT";
	private String TRIAGEGROUP_SELECT = "TRIAGEGROUP_SELECT";
	private String FACILITY_SELECT = "FACILITY_SELECT";
	private String REFRESH_INBOX ="REFRESHINBOX";
	private String reAssignRadioSelectSubmit;
	private String reAssignMemberSubmit;
	private Long clinicianId;
	private String surrogateName;
	private String STRUTS_CANCEL="CANCEL";
	private String STRUTS_VISN_CANCEL="VISN_CANCEL";
	private String STRUTS_SUCCESS="success";
	private String STRUTS_ERROR = "ERROR";
	private Collection<TriageGroup> stationTriageGroups;
	private Collection<TriageGroup> clinicianTriageGroups;
	private Collection<TriageGroup> stationTriageGroupsOSF;
	private Collection<TriageGroup> clinicianTriageGroupsOSF;
	private Collection<Facility> visns;
	private Collection<Facility> facilities;
	private String reAssignMemberCancel;
	private String reAssignRadioSelectCancel;
	private String reAssignComment;
	private String reAssignP2PComment;
	private String reAssignCommentOSF;
	private String reAssignP2PCommentOSF;
	private String reAssignTriageSubmit;
	private String reAssignTriageCancel;
	private String reAssignTriageYes;
	private String reAssignTriageNo;
	private String reAssignTriageOSFSubmit;
	private String reAssignTriageOSFCancel;
	private String reAssignTriageOSFYes;
	private String reAssignTriageOSFNo;
	private String reAssignVISNSelect;
	private String reAssignFacilitySelect;
	private String reAssignVISNCancel;
	private String reAssignFacilityCancel;
	private String reAssignFacilityYes;
	private String reAssignFacilityNo;
	private Long reAssignTriageGroupId;
	private Long reAssignClinicianTriageGroupId;
	private Long reAssignTriageGroupIdOSF;
	private Long reAssignClinicianTriageGroupIdOSF;
	private Long reAssignVISNId;
	private Long reAssignFacilityId;
	private String patientSSNAndDob;
	private String reAssignTriageGroupName;
	private String reAssignClinicianTriageGroupName;
	private String reAssignTriageGroupNameOSF;
	private String reAssignClinicianTriageGroupNameOSF;
	private Collection<ReAssignMessageHistory> reAssignMessageHistoryList;
	private boolean patientBlockedTgFlag=false;
	private String reAssignPatientBlockedOK;
	private String reAssignOptionGroup;

	public void prepare() throws Exception{
		super.prepare();
		STRUTS_RESULT = getCurrentUser().getUserType() == UserTypeEnum.PATIENT ? "PATIENT"
				: "CLINICIAN";
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());
		userService = (UserManagementService)ctx.getBean("userManagementService");
		facilityService = (FacilityService)ctx.getBean("facilityService");
		messageService = (MessageService)ctx.getBean("messageService");
		triageGroupService = (TriageGroupService) ctx.getBean("triageGroupService");
		patientBlockedService = (PatientBlockedService) ctx.getBean("patientBlockedService");
	}

	public String reAssignMessageWithInTriage()
	{
		getRequest().getSession().removeAttribute("facilities");
		getRequest().getSession().removeAttribute("displayVISNSelection");
		getRequest().getSession().removeAttribute("displayYesOrNoButtonForFacilityOSF");
		getRequest().getSession().removeAttribute("reAssignVISNName");
		getRequest().getSession().removeAttribute("reAssignVISNId");
		getRequest().getSession().removeAttribute("reAssignVISNSelected");
		getRequest().getSession().removeAttribute("reAssignFacilityName");
		getRequest().getSession().removeAttribute("reAssignFacilityId");
		getRequest().getSession().removeAttribute("reAssignFacilitySelected");

		getRequest().getSession().setAttribute(POPUPWINDOW,SELECT_OPTION);
		Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);

		if (getReAssignRadioSelectSubmit() != null){

			String reAssignMessageOption = getRequest().getParameter("reAssignOptionGroup");
			if(reAssignMessageOption.equals("1"))
			{
				getUsersSurrogateList(openedMessage.getRecipientId());
				getRequest().getSession().setAttribute(POPUPWINDOW,MEMBER_SELECT);
				return STRUTS_RESULT;
			}

			if(reAssignMessageOption.equals("2"))
			{
				getRequest().getSession().setAttribute(POPUPWINDOW,TRIAGEGROUP_SELECT);
				setStationTriageGroups(getTriageGroupsByStation());
				return STRUTS_RESULT;
			}
			if(reAssignMessageOption.equals("3"))
			{
				getRequest().getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
				setVisns(getAllVisns());
				//setStationTriageGroupsOSF(getTriageGroupsByStationOSF());
				return STRUTS_RESULT;
			}
		}
		if(getReAssignRadioSelectCancel()!=null){
			setupBean(openedMessage);
			return STRUTS_CANCEL;
		}
		return STRUTS_RESULT;
	}

	public String reAssignMessageP2P()
	{
		Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
			getRequest().getSession().setAttribute(POPUPWINDOW,TRIAGEGROUP_SELECT);
			setStationTriageGroups(getTriageGroupsByStation());
			return STRUTS_RESULT;
	}

	public String reAssignMessageFacility()
	{
		Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
			getRequest().getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
			setStationTriageGroupsOSF(getTriageGroupsByStationOSF());
			return STRUTS_RESULT;
	}

	public Collection<TriageGroup> getTriageGroupsByClinician(Clinician clinician1){
			Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
			Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());
			String  stationNumber = ((Clinician)getCurrentUser()).getStationNo();

			Collection<TriageGroup> patGroup = getTriageGroupDao().getTriageGroupsForPatientByStation(patient, stationNumber);

			Collection<TriageGroup> cliGroup = getTriageGroupDao().getTriageGroupsForClinician(clinician1);
			//The drop down list does not include the name of the triage group that is assigning the message
			for(TriageGroup tg:cliGroup){
				if(tg.getId().equals(openedMessage.getThread().getMailGroup().getId())){
					cliGroup.remove(tg);
					break;
				}
			}

			// If the patient is associated with a triage group, System will bold the triage group and display a (A) at the end of the triage group name
			for(TriageGroup tg:cliGroup){
				for(TriageGroup pg:patGroup){
					if(tg.getId().equals(pg.getId())){
						tg.setName(tg.getName()+"     (A)");
					}
				}
			}
			return cliGroup;
	}

	public Collection<TriageGroup> getTriageGroupsByClinicianOSF(Clinician clinician1){
			Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
			Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());
			//String  stationNumber = ((Clinician)getCurrentUser()).getStationNo();

			String facStationNumber = ((Facility)getFacilityDao().findById((Long)getRequest().getSession().getAttribute("reAssignFacilityId"))).getStationNumber();

			Collection<TriageGroup> patGroup = getTriageGroupDao().getTriageGroupsForPatientByStation(patient, facStationNumber);

			Collection<TriageGroup> cliGroup = getTriageGroupDao().getTriageGroupsForClinician(clinician1);
			//The drop down list does not include the name of the triage group that is assigning the message
			for(TriageGroup tg:cliGroup){
				if(tg.getId().equals(openedMessage.getThread().getMailGroup().getId())){
					cliGroup.remove(tg);
					break;
				}
			}

			// If the patient is associated with a triage group, System will bold the triage group and display a (A) at the end of the triage group name
			for(TriageGroup tg:cliGroup){
				for(TriageGroup pg:patGroup){
					if(tg.getId().equals(pg.getId())){
						tg.setName(tg.getName()+"     (A)");
					}
				}
			}
			return cliGroup;
	}

	public Collection<TriageGroup> getTriageGroupsByStation(){
		Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
		Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());
		String  stationNumber = ((Clinician)getCurrentUser()).getStationNo();

		Collection<TriageGroup> patGroup = getTriageGroupDao().getTriageGroupsForPatientByStation(patient, stationNumber);

		Collection<TriageGroup> staGroup = getTriageGroupDao().getTriageGroupsForStation(stationNumber);
		for(TriageGroup tg:staGroup){
			if(tg.getId().equals(openedMessage.getThread().getMailGroup().getId())){
				staGroup.remove(tg);
				break;
			}
		}

		// If the patient is associated with a triage group, System will bold the triage group and display a (A) at the end of the triage group name
		for(TriageGroup tg:staGroup){
			for(TriageGroup pg:patGroup){
				if(tg.getId().equals(pg.getId())){
					tg.setName(tg.getName()+"     (A)");
				}
			}
		}

		return staGroup;
	}

	public Collection<TriageGroup> getTriageGroupsByStationOSF(){
		Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
		Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());
		//String  stationNumber = ((Clinician)getCurrentUser()).getStationNo();

		String facStationNumber = ((Facility)getFacilityDao().findById((Long)getRequest().getSession().getAttribute("reAssignFacilityId"))).getStationNumber();
		Collection<TriageGroup> patGroup = getTriageGroupDao().getTriageGroupsForPatientByStation(patient, facStationNumber);

		Collection<TriageGroup> staGroup = getTriageGroupDao().getTriageGroupsForStation(facStationNumber);
		for(TriageGroup tg:staGroup){
			if(tg.getId().equals(openedMessage.getThread().getMailGroup().getId())){
				staGroup.remove(tg);
				break;
			}
		}

		// If the patient is associated with a triage group, System will bold the triage group and display a (A) at the end of the triage group name
		for(TriageGroup tg:staGroup){
			for(TriageGroup pg:patGroup){
				if(tg.getId().equals(pg.getId())){
					tg.setName(tg.getName()+"     (A)");
				}
			}
		}

		return staGroup;
	}

	public Collection<Facility> getAllVisns(){
		Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
		Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());
		String  stationNumber = ((Clinician)getCurrentUser()).getStationNo();

		Collection<Facility> visnList = getFacilityDao().getVisns();
		return visnList;
	}

	public Collection<Facility> getFacilitiesByVisn(String visnName){
		//Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
		//Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());
		String  stationNumber = ((Clinician)getCurrentUser()).getStationNo();

		//Get facility of the current user - Healthcare team member
		Facility f = facilityService.getFacilityByStationNumber(stationNumber).getPayload();
		Collection<Facility> facilityList = getFacilityDao().getFacilityByVisn(visnName);

		if (f != null){
			//The current facility of the Healthcare team member is not listed in the drop down
			for(Facility fl:facilityList){
				if(fl.getId().equals(f.getId())){
					facilityList.remove(fl);
					break;
				}
			}
		}
		else
		{
			if(log.isInfoEnabled()){
				log.info("There is no facility setup for the current user.");
			}
		}
		return facilityList;
	}

	public String reAssignMemberSelectSubmit(){
		Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);

		if(getReAssignMemberSubmit()!=null){
			if(getClinicianId().equals(new Long("-1"))){
				addFieldError("reAssigneeSelectError","Please select ReAssignee");
				getUsersSurrogateList(openedMessage.getRecipientId());
				return STRUTS_RESULT;

			}else{

				Clinician assignedBy = (Clinician)getCurrentUser();
				Clinician assignedTo = getUserDao().findClinicianById(getClinicianId());
				ServiceResponse<Boolean> serviceResponse = getMessageService().assignMessageAndUpdateHistory(openedMessage, assignedTo, assignedBy, assignedTo.getName()+" "+getSurrogateEnabled());
				if(!getReAssignComment().trim().equals("")){
					Annotation annotateComments = new Annotation();
					annotateComments.setAnnotation(getReAssignComment());
					annotateComments.setAuthor(assignedBy);
					annotateComments.setThread(openedMessage.getThread());
					getMessageService().annotateThread(annotateComments);
					openedMessage.getThread().getAnnotations().add(annotateComments);
					//getRequest().getSession().setAttribute(CURRENT_MESSAGE, openedMessage); // Not required if we redirecting to REFRESHINBOX, if we redirect to READ MESSAGE PAGE, Its required
				}

				if(!serviceResponse.getPayload()){
			    	addActionError("An Error Occured while reassigning message, please try again later.");
			    	getUsersSurrogateList(openedMessage.getRecipientId());
			    	return STRUTS_ERROR;
			    }
				return REFRESH_INBOX;
			}
		}
		if(getReAssignMemberCancel()!=null){
			return STRUTS_CANCEL;
		}

		return STRUTS_CANCEL;
	}


	public String reAssignToAnotherProvider(){
		String displayYesOrNoButtonForCli = "Yes";
		Boolean manuallyAssociate = false;
		User user = (User)getRequest().getSession().getAttribute(CURRENT_USER);
		//String tab=getRequest().getParameter("tab");
		if(getRequest().getParameter("search") != null)
		{
			getRequest().getSession().removeAttribute("clinicians");
			getRequest().getSession().removeAttribute("p2pClinician1");

			String lastNameP2P = (String)getRequest().getParameter("lastNameP2P");
			// must provide a last name
			if(StringUtils.isBlank(lastNameP2P))
			{
				lastNameP2P=lastNameP2P.trim();
				getRequest().getSession().setAttribute("lastNameP2P", lastNameP2P);
				return "select";
			}

			String firstNameP2P = (String)getRequest().getParameter("firstNameP2P");
			if (firstNameP2P != null)
				firstNameP2P=firstNameP2P.trim();

			getRequest().getSession().setAttribute("firstNameP2P", firstNameP2P);
			getRequest().getSession().setAttribute("lastNameP2P", lastNameP2P);

			try {
				CollectionServiceResponse<Clinician> response = userService
						.searchForClinicians(firstNameP2P, lastNameP2P,
								((Clinician) user).getStationNo(), true);
				Collection<Clinician> pts = response.getCollection();

				//Collection<Clinician> sortedClinicians = new TreeSet<Clinician>(User.USER_BY_NAME_SORTER);
				//sortedClinicians.addAll(pts);
				//getRequest().getSession().setAttribute("clinicians", sortedClinicians);
				getRequest().getSession().setAttribute("clinicians", pts);
			} catch (Exception e) {
				addActionError("Search resulted in error.");
				return "select";
			}
			return "select";
		}
		else if(getRequest().getParameter("select")!=null)
		{
			Long id=null;
			try	{
				id = new Long((String)getRequest().getParameter("p2pClinician1"));
			}catch(Exception e){
				return "select";
			}
			Collection<Clinician> cns = (Collection<Clinician>)getRequest().getSession().getAttribute("clinicians");
			User p2pClinician = null;
			for(Clinician c : cns){
				if(c.getId().equals(id)){
					p2pClinician = c;
					getRequest().getSession().setAttribute("p2pClinician1", p2pClinician);
					WebApplicationContext ctx = WebApplicationContextUtils
					.getWebApplicationContext(ServletActionContext
							.getServletContext());
					IntegrationServiceDelegate delegate = (IntegrationServiceDelegate)ctx.getBean("integrationServiceDelegate");
					UserLookupResponse ulr = null;
					try
					{
						getRequest().getSession().removeAttribute("p2pClinician1Facility");
						getRequest().getSession().removeAttribute("p2pClinician1Demographics");

						Facility f = facilityService.getFacilityByStationNumber(c.getStationNo()).getPayload();
						if (f != null) {
							getRequest().getSession().setAttribute("p2pClinician1Facility", f.getName());
						} else {
							if(log.isErrorEnabled()){
								log.error("No facility for station " + c.getStationNo());
							}
						}

						if(log.isDebugEnabled()){
							log.debug("New - About to get user demographics for " + c.getFirstName() + " " + c.getLastName() + ", using DUZ=" + c.getDuz() + " on station " + c.getStationNo());
						}
						boolean userFound = false;
						ulr = delegate.getUserDemographics(null, null, c.getDuz(), c.getStationNo());
						if("Ok".equalsIgnoreCase(ulr.getStatus())) {
							if (ulr.getUsers()!= null && ulr.getUsers().length > 0) {
								// SUCCESS
								if(log.isDebugEnabled()){
									log.debug("Found clinician demographics for " + ulr.getUsers().length + " users");
								}
								gov.va.med.mhv.sm.wsclient.queriessvc.User[] users = ulr.getUsers();
								if (users.length != 1) {
									if(log.isErrorEnabled()){
										log.error("User demographics query retrieved " + users.length + " results when only 1 was expected: conversationID = " + ulr.getConversationID());
									}
								} else if (users[0] != null) {
									userFound = true;
									if(log.isDebugEnabled()){
										log.debug("User demographics found: " + users[0].getFirstName() + " " + users[0].getLastName() + ": department = " + users[0].getDepartment() + ", phone = " + users[0].getPhone());
									}
									getRequest().getSession().setAttribute("p2pClinician1Demographics", users[0]);
								}
							}
						} else {
							if(log.isErrorEnabled()){
								log.error("User demographics query for " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo() + " returned " + ulr.getStatus() + ": conversationID = " + ulr.getConversationID());
							}
						}
						if (!userFound) {
							if(log.isErrorEnabled()){
								log.error("No users found matching " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo());
							}
						}
					} catch (Exception e) {
						if(log.isErrorEnabled()){
							log.error("Exception raised trying to retrieve user demographics for = " + c.getFirstName() + " " + c.getLastName() + ": DUZ/station = " + c.getDuz() + "/" + c.getStationNo());
						}
						if (ulr == null) {
							if(log.isErrorEnabled()){
								log.error("No conversation ID");
							}
						} else {
							if(log.isErrorEnabled()){
								log.error("Conversation ID = " + ulr.getConversationID());
							}
						}
						e.printStackTrace();
					}
					break;
				}
			}
			Clinician clinician1 = (Clinician)getUserDao().findById(id);
			Collection<TriageGroup> cliGroup = getTriageGroupsByClinician(clinician1);
			setClinicianTriageGroups(cliGroup);
			getRequest().getSession().setAttribute("clinicianTriageGroups", cliGroup);
			return "select";
		}
		else if(getRequest().getParameter("no")!=null)
		{
			displayYesOrNoButtonForCli = "No";
			getRequest().getSession().setAttribute("displayYesOrNoButtonForCli", displayYesOrNoButtonForCli);
			setClinicianTriageGroups((Collection<TriageGroup>)getRequest().getSession().getAttribute("clinicianTriageGroups"));
			getRequest().getSession().setAttribute("reAssignP2PComment", (String)getRequest().getParameter("reAssignP2PComment"));
		}
		else if(getRequest().getParameter("submit")!=null || getRequest().getParameter("yes")!=null)
		{
			getRequest().getSession().removeAttribute("displayYesOrNoButtonForCli");
			getRequest().getSession().setAttribute("reAssignP2PComment", (String)getRequest().getParameter("reAssignP2PComment"));
			String tgName = ((TriageGroup)getTriageGroupDao().findById(getReAssignClinicianTriageGroupId())).getName();
			setReAssignClinicianTriageGroupName(tgName);
			getRequest().getSession().setAttribute("reAssignClinicianTriageGroupName",tgName);
			getRequest().getSession().setAttribute("reAssignClinicianTriageGroupId",(getReAssignClinicianTriageGroupId().toString()));


			//TriageGroup reAssignTriageTriageGroup = (TriageGroup)getTriageGroupDao().findById(getReAssignClinicianTriageGroupId());

			if(getRequest().getParameter("submit")!=null)
			{
				// validates if the patient belongs to the selected Triage group
				Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
				Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());
				String  stationNumber = ((Clinician)getCurrentUser()).getStationNo();

				Collection<TriageGroup> patGroup = getTriageGroupDao().getTriageGroupsForPatientByStation(patient, stationNumber);

				//Check if the Patient belongs to the selected Triage group
				for(TriageGroup tg:patGroup){
					if(tg.getId().equals(getReAssignClinicianTriageGroupId())){
						displayYesOrNoButtonForCli="No";
						break;
					}
				}
				getRequest().getSession().setAttribute("displayYesOrNoButtonForCli", displayYesOrNoButtonForCli);
				if (displayYesOrNoButtonForCli.equals("Yes")){
					setClinicianTriageGroups((Collection<TriageGroup>)getRequest().getSession().getAttribute("clinicianTriageGroups"));
					return "select";
				}

				// TO DO, Check whether the patient is Blocked from SM or Blocked from TG and display the error message
				if(checkPatientBlockedFromFacility(patient, getReAssignClinicianTriageGroupId()) ||
					     checkPatientBlockedFromTG(patient, getReAssignClinicianTriageGroupId())){
					setPatientBlockedTgFlag(true);
					setClinicianTriageGroups((Collection<TriageGroup>)getRequest().getSession().getAttribute("clinicianTriageGroups"));
					return "select";
				}


			}
			if(getRequest().getParameter("yes")!=null)
			{
				displayYesOrNoButtonForCli="No";
				// Manually Associate the patient with this Triage Group
				manuallyAssociate = true;

				Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
				Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());

				// If selected Yes, now check if the patient is blocked from the TG or Facility
				if(checkPatientBlockedFromFacility(patient, getReAssignClinicianTriageGroupId()) ||
					     checkPatientBlockedFromTG(patient, getReAssignClinicianTriageGroupId())){
					setPatientBlockedTgFlag(true);
					setClinicianTriageGroups((Collection<TriageGroup>)getRequest().getSession().getAttribute("clinicianTriageGroups"));
					return "select";
				}
			}

			Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
			Clinician p2pClinician1 = (Clinician) getRequest().getSession().getAttribute("p2pClinician1");
			Long p2pClinician1Id = new Long(p2pClinician1.getId());
			Long origTriageGroupId = new Long(openedMessage.getRecipientId());

	      	Message updatedMessage = getMessageService().reAssignMessage(openedMessage.getId(),
	      																origTriageGroupId,
	      																getReAssignClinicianTriageGroupId(),
	      																p2pClinician1Id,
	      																manuallyAssociate,
	      																getCurrentUser(),
	      																ReAssignMessageActionEnum.REASSIGN_ANOTHER_STAFF_WITH_IN_FACILITY).getPayload();
			if(updatedMessage==null){
				 addActionError("An Error Occured while reassigning message to Another Staff, please try again later.");
				 return STRUTS_ERROR;
			}
			if(!getReAssignP2PComment().trim().equals("")){
					Annotation annotateComments = new Annotation();
					annotateComments.setAnnotation(getReAssignP2PComment());
					annotateComments.setAuthor(getCurrentUser());
					annotateComments.setThread(updatedMessage.getThread());
					getMessageService().annotateThread(annotateComments);
					updatedMessage.getThread().getAnnotations().add(annotateComments);
			}
			getRequest().getSession().setAttribute(CURRENT_MESSAGE, updatedMessage);

			if (displayYesOrNoButtonForCli.equals("No")) {
				//cleanup
				getRequest().getSession().removeAttribute("clinicians");
				getRequest().getSession().removeAttribute("firstNameP2P");
				getRequest().getSession().removeAttribute("lastNameP2P");
				getRequest().getSession().removeAttribute("p2pClinician1");
				getRequest().getSession().removeAttribute("reAssignP2PComment");
			}
			return REFRESH_INBOX;
		}
		else if(getRequest().getParameter("cancel")!=null)
		{
			//cleanup
			getRequest().getSession().removeAttribute("clinicians");
			getRequest().getSession().removeAttribute("firstNameP2P");
			getRequest().getSession().removeAttribute("lastNameP2P");
			getRequest().getSession().removeAttribute("p2pClinician1");
			getRequest().getSession().removeAttribute("reAssignP2PComment");
			return STRUTS_CANCEL;
		}

		if(getReAssignPatientBlockedOK()!=null){
			setPatientBlockedTgFlag(false);
			setClinicianTriageGroups((Collection<TriageGroup>)getRequest().getSession().getAttribute("clinicianTriageGroups"));
			return "select";
		}

		return STRUTS_RESULT;
	}

	public String reAssignToAnotherProviderOSF(){
		String displayYesOrNoButtonForCliOSF = "Yes";
		Boolean manuallyAssociateOSF = false;
		User user = (User)getRequest().getSession().getAttribute(CURRENT_USER);
		//String tab=getRequest().getParameter("tab");
		if(getRequest().getParameter("search") != null)
		{
			getRequest().getSession().removeAttribute("cliniciansOSF");
			getRequest().getSession().removeAttribute("osfClinician1");

			String lastNameOSF = (String)getRequest().getParameter("lastNameOSF");
			// must provide a last name
			if(StringUtils.isBlank(lastNameOSF))
			{
				lastNameOSF=lastNameOSF.trim();
				getRequest().getSession().setAttribute("lastNameOSF", lastNameOSF);
				return "select";
			}

			String firstNameOSF = (String)getRequest().getParameter("firstNameOSF");
			if (firstNameOSF != null)
				firstNameOSF=firstNameOSF.trim();

			getRequest().getSession().setAttribute("firstNameOSF", firstNameOSF);
			getRequest().getSession().setAttribute("lastNameOSF", lastNameOSF);

			try {
				CollectionServiceResponse<Clinician> response = userService.searchForClinicians(firstNameOSF, lastNameOSF,((Facility)getFacilityDao().findById((Long)getRequest().getSession().getAttribute("reAssignFacilityId"))).getStationNumber(), true);
				Collection<Clinician> pts = response.getCollection();

				//Collection<Clinician> sortedClinicians = new TreeSet<Clinician>(User.USER_BY_NAME_SORTER);
				//sortedClinicians.addAll(pts);
				//getRequest().getSession().setAttribute("clinicians", sortedClinicians);
				getRequest().getSession().setAttribute("cliniciansOSF", pts);
			} catch (Exception e) {
				addActionError("Search resulted in error.");
				return "select";
			}
			return "select";
		}
		else if(getRequest().getParameter("select")!=null)
		{
			Long id=null;
			try	{
				id = new Long((String)getRequest().getParameter("osfClinician1"));
			}catch(Exception e){
				return "select";
			}
			Collection<Clinician> cns = (Collection<Clinician>)getRequest().getSession().getAttribute("cliniciansOSF");
			User osfClinician = null;
			for(Clinician c : cns){
				if(c.getId().equals(id)){
					osfClinician = c;
					getRequest().getSession().setAttribute("osfClinician1", osfClinician);
					WebApplicationContext ctx = WebApplicationContextUtils
					.getWebApplicationContext(ServletActionContext
							.getServletContext());
					IntegrationServiceDelegate delegate = (IntegrationServiceDelegate)ctx.getBean("integrationServiceDelegate");
					UserLookupResponse ulr = null;
					try
					{
						getRequest().getSession().removeAttribute("osfClinician1Facility");
						getRequest().getSession().removeAttribute("osfClinician1Demographics");

						Facility f = facilityService.getFacilityByStationNumber(c.getStationNo()).getPayload();
						if (f != null) {
							getRequest().getSession().setAttribute("osfClinician1Facility", f.getName());
						} else {
							if(log.isErrorEnabled()){
								log.error("No facility for station " + c.getStationNo());
							}
						}

						if(log.isDebugEnabled()){
							log.debug("New - About to get user demographics for " + c.getFirstName() + " " + c.getLastName() + ", using DUZ=" + c.getDuz() + " on station " + c.getStationNo());
						}
						boolean userFound = false;
						ulr = delegate.getUserDemographics(null, null, c.getDuz(), c.getStationNo());
						if("Ok".equalsIgnoreCase(ulr.getStatus())) {
							if (ulr.getUsers()!= null && ulr.getUsers().length > 0) {
								// SUCCESS
								if(log.isDebugEnabled()){
									log.debug("Found clinician demographics for " + ulr.getUsers().length + " users");
								}
								gov.va.med.mhv.sm.wsclient.queriessvc.User[] users = ulr.getUsers();
								if (users.length != 1) {
									if(log.isErrorEnabled()){
										log.error("User demographics query retrieved " + users.length + " results when only 1 was expected: conversationID = " + ulr.getConversationID());
									}
								} else if (users[0] != null) {
									userFound = true;
									if(log.isDebugEnabled()){
										log.debug("User demographics found: " + users[0].getFirstName() + " " + users[0].getLastName() + ": department = " + users[0].getDepartment() + ", phone = " + users[0].getPhone());
									}
									getRequest().getSession().setAttribute("osfClinician1Demographics", users[0]);
								}
							}
						} else {
							if(log.isErrorEnabled()){
								log.error("User demographics query for " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo() + " returned " + ulr.getStatus() + ": conversationID = " + ulr.getConversationID());
							}
						}
						if (!userFound) {
							if(log.isErrorEnabled()){
								log.error("No users found matching " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo());
							}
						}
					} catch (Exception e) {
						if(log.isErrorEnabled()){
							log.error("Exception raised trying to retrieve user demographics for = " + c.getFirstName() + " " + c.getLastName() + ": DUZ/station = " + c.getDuz() + "/" + c.getStationNo());
						}
						if (ulr == null) {
							if(log.isErrorEnabled()){
								log.error("No conversation ID");
							}
						} else {
							if(log.isErrorEnabled()){
								log.error("Conversation ID = " + ulr.getConversationID());
							}
						}
						e.printStackTrace();
					}
					break;
				}
			}
			Clinician clinician1 = (Clinician)getUserDao().findById(id);
			Collection<TriageGroup> cliGroup = getTriageGroupsByClinicianOSF(clinician1);
			setClinicianTriageGroupsOSF(cliGroup);
			getRequest().getSession().setAttribute("clinicianTriageGroupsOSF", cliGroup);
			return "select";
		}
		else if(getReAssignPatientBlockedOK()!=null){
			if(log.isInfoEnabled()){
				log.info("$$$$$$$$$$$$$$$$$$$$$$$$$$$OK Button Pressed-Reassign to outside facily clinician...............");
			}
			setPatientBlockedTgFlag(false);
			setClinicianTriageGroupsOSF((Collection<TriageGroup>)getRequest().getSession().getAttribute("clinicianTriageGroupsOSF"));
			return "select";
		}

		else if(getRequest().getParameter("no")!=null)
		{
			displayYesOrNoButtonForCliOSF = "No";
			getRequest().getSession().setAttribute("displayYesOrNoButtonForCliOSF", displayYesOrNoButtonForCliOSF);
			setClinicianTriageGroupsOSF((Collection<TriageGroup>)getRequest().getSession().getAttribute("clinicianTriageGroupsOSF"));
			getRequest().getSession().setAttribute("reAssignP2PCommentOSF", (String)getRequest().getParameter("reAssignP2PCommentOSF"));
		}
		else if(getRequest().getParameter("submit")!=null || getRequest().getParameter("yes")!=null)
		{
			getRequest().getSession().removeAttribute("displayYesOrNoButtonForCliOSF");
			getRequest().getSession().setAttribute("reAssignP2PCommentOSF", (String)getRequest().getParameter("reAssignP2PCommentOSF"));
			String tgName = ((TriageGroup)getTriageGroupDao().findById(getReAssignClinicianTriageGroupIdOSF())).getName();
			setReAssignClinicianTriageGroupNameOSF(tgName);
			getRequest().getSession().setAttribute("reAssignClinicianTriageGroupNameOSF",tgName);
			getRequest().getSession().setAttribute("reAssignClinicianTriageGroupIdOSF",(getReAssignClinicianTriageGroupIdOSF().toString()));

			if(getRequest().getParameter("submit")!=null)
			{
				// validates if the patient belongs to the selected Triage group
				Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
				Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());
				//String  stationNumber = ((Clinician)getCurrentUser()).getStationNo();

				String facStationNumber = ((Facility)getFacilityDao().findById((Long)getRequest().getSession().getAttribute("reAssignFacilityId"))).getStationNumber();

				Collection<TriageGroup> patGroup = getTriageGroupDao().getTriageGroupsForPatientByStation(patient, facStationNumber);

				//Check if the Patient belongs to the selected Triage group
				for(TriageGroup tg:patGroup){
					if(tg.getId().equals(getReAssignClinicianTriageGroupIdOSF())){
						displayYesOrNoButtonForCliOSF="No";
						break;
					}
				}
				getRequest().getSession().setAttribute("displayYesOrNoButtonForCliOSF", displayYesOrNoButtonForCliOSF);
				if (displayYesOrNoButtonForCliOSF.equals("Yes")){
					setClinicianTriageGroupsOSF((Collection<TriageGroup>)getRequest().getSession().getAttribute("clinicianTriageGroupsOSF"));
					return "select";
				}
				if(checkPatientBlockedFromFacility(patient, getReAssignClinicianTriageGroupIdOSF()) ||
					     checkPatientBlockedFromTG(patient, getReAssignClinicianTriageGroupIdOSF())){
					setPatientBlockedTgFlag(true);
					setClinicianTriageGroupsOSF((Collection<TriageGroup>)getRequest().getSession().getAttribute("clinicianTriageGroupsOSF"));
					return "select";
				}

			}

			if(getRequest().getParameter("yes")!=null)
			{
				displayYesOrNoButtonForCliOSF="No";
				// Manually Associate the patient with this Triage Group
				manuallyAssociateOSF = true;

				Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
				Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());

				// If selected Yes, now check if the patient is blocked from the TG or Facility
				if(checkPatientBlockedFromFacility(patient, getReAssignClinicianTriageGroupIdOSF()) ||
					     checkPatientBlockedFromTG(patient, getReAssignClinicianTriageGroupIdOSF())){
					setPatientBlockedTgFlag(true);
					setClinicianTriageGroupsOSF((Collection<TriageGroup>)getRequest().getSession().getAttribute("clinicianTriageGroupsOSF"));
					return "select";
				}
			}

			Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
			Clinician osfClinician1 = (Clinician) getRequest().getSession().getAttribute("osfClinician1");
			Long osfClinician1Id = new Long(osfClinician1.getId());
			Long origTriageGroupId = new Long(openedMessage.getRecipientId());

	      	Message updatedMessage = getMessageService().reAssignMessage(openedMessage.getId(),
	      																origTriageGroupId,
	      																getReAssignClinicianTriageGroupIdOSF(),
	      																osfClinician1Id,
	      																manuallyAssociateOSF,
	      																getCurrentUser(),
	      																ReAssignMessageActionEnum.MESSAGE_TRANSFERRED_STAFF_OUTSIDE_FACILITY).getPayload();
			if(updatedMessage==null){
				 addActionError("An Error Occured while reassigning message to Another Staff, please try again later.");
				 return STRUTS_ERROR;
			}
			if(!getReAssignP2PCommentOSF().trim().equals("")){
					Annotation annotateComments = new Annotation();
					annotateComments.setAnnotation(getReAssignP2PCommentOSF());
					annotateComments.setAuthor(getCurrentUser());
					annotateComments.setThread(updatedMessage.getThread());
					getMessageService().annotateThread(annotateComments);
					updatedMessage.getThread().getAnnotations().add(annotateComments);
			}
			getRequest().getSession().setAttribute(CURRENT_MESSAGE, updatedMessage);

			if (displayYesOrNoButtonForCliOSF.equals("No")) {
				//cleanup
				getRequest().getSession().removeAttribute("cliniciansOSF");
				getRequest().getSession().removeAttribute("firstNameOSF");
				getRequest().getSession().removeAttribute("lastNameOSF");
				getRequest().getSession().removeAttribute("osfClinician1");
				getRequest().getSession().removeAttribute("reAssignP2PCommentOSF");
			}

			return REFRESH_INBOX;
		}
		else if(getRequest().getParameter("cancel")!=null)
		{
			//cleanup
			getRequest().getSession().removeAttribute("cliniciansOSF");
			getRequest().getSession().removeAttribute("firstNameOSF");
			getRequest().getSession().removeAttribute("lastNameOSF");
			getRequest().getSession().removeAttribute("osfClinician1");
			getRequest().getSession().removeAttribute("reAssignP2PCommentOSF");
			return STRUTS_CANCEL;
		}

		return STRUTS_RESULT;
	}

	public String reAssignToFacilityVISNSelection(){
		String displayVISNSelection = "Yes";
		String displayYesOrNoButtonForFacilityOSF = "No";
		getRequest().getSession().setAttribute("displayYesOrNoButtonForFacilityOSF",displayYesOrNoButtonForFacilityOSF );
		if(getReAssignVISNSelect()!=null)
		{
			//List VISNs
			//No code required here for initial listing of the VISNs.

			//VISN Selected and LIST Facility
			// --Display selected VISN
			// --Get Name of the Selected VISN
			// --Get the list of Facilities for the Selected VISN

			if (getReAssignVISNId() == null)
				setReAssignVISNId((Long)getRequest().getSession().getAttribute("reAssignVISNId"));

			if (getReAssignVISNId() != -1)
			{
				//getRequest().getSession().removeAttribute("displayVISNSelection");
				displayVISNSelection = "Yes";
				getRequest().getSession().setAttribute("displayVISNSelection",displayVISNSelection );
				String visnName = ((Facility)getFacilityDao().findById(getReAssignVISNId())).getName();
				getRequest().getSession().setAttribute("reAssignVISNName",visnName);
				getRequest().getSession().setAttribute("reAssignVISNId",getReAssignVISNId());
				setFacilities(getFacilitiesByVisn(visnName));
				getRequest().getSession().setAttribute("reAssignVISNSelected","Yes");
				getRequest().getSession().setAttribute("reAssignFacilitySelected","No");
				getRequest().getSession().removeAttribute("reAssignFacilityName");
				getRequest().getSession().removeAttribute("reAssignFacilityId");
				getRequest().getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
			}
			else
			{
				//getRequest().getSession().removeAttribute("displayVISNSelection");
				setVisns(getAllVisns());
				displayVISNSelection = "Yes";
				getRequest().getSession().setAttribute("displayVISNSelection",displayVISNSelection );
				getRequest().getSession().setAttribute("reAssignVISNSelected","No");
				getRequest().getSession().setAttribute("reAssignFacilitySelected","No");
				getRequest().getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
			}
		}
		else if(getReAssignFacilitySelect() !=null)
		{
			//VISN and Facility Selected
			// --Display selected Facility
			// -- get the name of the Facility selected
			// Check if the patient belongs to the selected facility. if not, display the Yes/No confirmation message.
			// forward screens to Display Tabs (clinician and TG)

			if (getReAssignFacilityId() != -1)
			{
				Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
				Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());

				Collection<PatientFacility> facilityList = patient.getFacilities();
				for(PatientFacility fl:facilityList){
					if(fl.getStationNo().equals(((Facility)getFacilityDao().findById(getReAssignFacilityId())).getStationNumber())){
						displayYesOrNoButtonForFacilityOSF = "No";
						getRequest().getSession().setAttribute("displayYesOrNoButtonForFacilityOSF",displayYesOrNoButtonForFacilityOSF );
						break;
					}
					else{
						displayYesOrNoButtonForFacilityOSF = "Yes";
						getRequest().getSession().setAttribute("displayYesOrNoButtonForFacilityOSF",displayYesOrNoButtonForFacilityOSF );
					}
				}

				if (displayYesOrNoButtonForFacilityOSF.equals("No")) {
					displayVISNSelection = "No";
				}
				else {
					displayVISNSelection = "Yes";
				}

				//Check if the notification was already sent for this patient, system shall display the message
				ServiceResponse<PatientReassignFacility> patientReassignFacility = getReAssignMessageService().getPatientReassignFacilityByStationAndPatient(new Long(((Facility)getFacilityDao().findById(getReAssignFacilityId())).getStationNumber()),openedMessage.getSenderId());

				//is patientReassignFacility is not null, notification is already sent and display the message "A notification was sent to the facilitys SM Administrator(s)"
				if(patientReassignFacility.getPayload() != null){
						displayYesOrNoButtonForFacilityOSF = "Ok";
						getRequest().getSession().setAttribute("displayYesOrNoButtonForFacilityOSF",displayYesOrNoButtonForFacilityOSF );
				}

				//getRequest().getSession().removeAttribute("displayVISNSelection");
				getRequest().getSession().setAttribute("displayVISNSelection",displayVISNSelection );
				String facilityName = ((Facility)getFacilityDao().findById(getReAssignFacilityId())).getName();
				getRequest().getSession().setAttribute("reAssignFacilityName",facilityName);
				getRequest().getSession().setAttribute("reAssignFacilityId",getReAssignFacilityId());
				getRequest().getSession().setAttribute("reAssignFacilitySelected","Yes");
				getRequest().getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
			}
			else
			{
				String visnName = ((Facility)getFacilityDao().findById((Long)getRequest().getSession().getAttribute("reAssignVISNId"))).getName();
				setFacilities(getFacilitiesByVisn(visnName));
				getRequest().getSession().setAttribute("displayVISNSelection",displayVISNSelection );
				getRequest().getSession().setAttribute("reAssignFacilitySelected","No");
				getRequest().getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
			}
		}
		else if(getReAssignFacilityYes() !=null)
		{
			// Send email notification
			// Closes the screen and we are back at message display

			// <<<<< Method here to send notification.. >>>>>>>
			Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
			String stationNumber = ((Facility)getFacilityDao().findById((Long)getRequest().getSession().getAttribute("reAssignFacilityId"))).getStationNumber();
	      	Boolean notificationSent = getMessageService().nofityFacilityAdminsAddPatientToFacility(openedMessage.getId(),
	      																new Long(stationNumber),
	      																getCurrentUser()).getPayload();
			if(notificationSent==Boolean.FALSE){
				 addActionError("An Error Occured while sending the notification to the facility SM Administrator(s) to associate the patient with the facility.");
				 return STRUTS_ERROR;
			}

			getRequest().getSession().removeAttribute("facilities");
			getRequest().getSession().removeAttribute("displayVISNSelection");
			getRequest().getSession().removeAttribute("displayYesOrNoButtonForFacilityOSF");
			getRequest().getSession().removeAttribute("reAssignVISNName");
			getRequest().getSession().removeAttribute("reAssignVISNId");
			getRequest().getSession().removeAttribute("reAssignVISNSelected");
			getRequest().getSession().removeAttribute("reAssignFacilityName");
			getRequest().getSession().removeAttribute("reAssignFacilityId");
			getRequest().getSession().removeAttribute("reAssignFacilitySelected");
			return STRUTS_CANCEL;
		}
		else if(getReAssignFacilityNo() !=null)
		{
			// Goto the VISN Selection window.
			setVisns(getAllVisns());
			getRequest().getSession().removeAttribute("facilities");
			getRequest().getSession().removeAttribute("displayVISNSelection");
			getRequest().getSession().removeAttribute("displayYesOrNoButtonForFacilityOSF");
			getRequest().getSession().removeAttribute("reAssignVISNName");
			getRequest().getSession().removeAttribute("reAssignVISNId");
			getRequest().getSession().removeAttribute("reAssignVISNSelected");
			getRequest().getSession().removeAttribute("reAssignFacilityName");
			getRequest().getSession().removeAttribute("reAssignFacilityId");
			getRequest().getSession().removeAttribute("reAssignFacilitySelected");
		}
		else if(getReAssignVISNCancel()!=null)
		{
			setVisns(getAllVisns());
			getRequest().getSession().removeAttribute("facilities");
			getRequest().getSession().removeAttribute("displayVISNSelection");
			getRequest().getSession().removeAttribute("displayYesOrNoButtonForFacilityOSF");
			getRequest().getSession().removeAttribute("reAssignVISNName");
			getRequest().getSession().removeAttribute("reAssignVISNId");
			getRequest().getSession().removeAttribute("reAssignVISNSelected");
			getRequest().getSession().removeAttribute("reAssignFacilityName");
			getRequest().getSession().removeAttribute("reAssignFacilityId");
			getRequest().getSession().removeAttribute("reAssignFacilitySelected");
			getRequest().getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
			return STRUTS_VISN_CANCEL;
			// Make a call to action.
			//("reAssignMessageWithInTriage.action?reAssignRadioSelectSubmit=Submit&reAssignOptionGroup=3");

		}
		else if(getReAssignFacilityCancel()!=null)
		{
			setVisns(getAllVisns());
			getRequest().getSession().removeAttribute("facilities");
			getRequest().getSession().removeAttribute("displayVISNSelection");
			getRequest().getSession().removeAttribute("displayYesOrNoButtonForFacilityOSF");
			getRequest().getSession().removeAttribute("reAssignVISNName");
			getRequest().getSession().removeAttribute("reAssignVISNId");
			getRequest().getSession().removeAttribute("reAssignVISNSelected");
			getRequest().getSession().removeAttribute("reAssignFacilityName");
			getRequest().getSession().removeAttribute("reAssignFacilityId");
			getRequest().getSession().removeAttribute("reAssignFacilitySelected");
			getRequest().getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
			return STRUTS_VISN_CANCEL;
		}

		return STRUTS_RESULT;
	}

	public String reAssignToAnotherTriageGroup(){
		String displayYesOrNoButtonForTG = "Yes";
		Boolean manuallyAssociate = false;
		if(getReAssignTriageSubmit()!=null || getReAssignTriageYes()!=null)
		{
			getRequest().getSession().removeAttribute("displayYesOrNoButtonForTG");
			getRequest().getSession().setAttribute("reAssignComment", (String)getRequest().getParameter("reAssignComment"));
			String tgName = ((TriageGroup)getTriageGroupDao().findById(getReAssignTriageGroupId())).getName();
			getRequest().getSession().setAttribute("reAssignTriageGroupName",tgName);
			setReAssignTriageGroupName(tgName);
			getRequest().getSession().setAttribute("reAssignTriageGroupId",(getReAssignTriageGroupId().toString()));

			if(getReAssignTriageSubmit()!=null)
			{
				// validates if the patient belongs to the selected Triage group
				Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
				Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());
				String  stationNumber = ((Clinician)getCurrentUser()).getStationNo();

				Collection<TriageGroup> patGroup = getTriageGroupDao().getTriageGroupsForPatientByStation(patient, stationNumber);

				//Check if the Patient belongs to the selected Triage group
				for(TriageGroup tg:patGroup){
					if(tg.getId().equals(getReAssignTriageGroupId())){
						displayYesOrNoButtonForTG="No";
						break;
					}
				}
				getRequest().getSession().setAttribute("displayYesOrNoButtonForTG", displayYesOrNoButtonForTG);
				if (displayYesOrNoButtonForTG.equals("Yes")){
					setStationTriageGroups(getTriageGroupsByStation());
					return "select";
				}

				if(checkPatientBlockedFromFacility(patient, getReAssignTriageGroupId()) ||
					     checkPatientBlockedFromTG(patient, getReAssignTriageGroupId())){
					setPatientBlockedTgFlag(true);
					setStationTriageGroups(getTriageGroupsByStation());
					return "select";
				}

			}
			if(getReAssignTriageYes()!=null)
			{
				displayYesOrNoButtonForTG="No";
				// Manually Associate the patient with this Triage Group
				manuallyAssociate = true;

				Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
				Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());

				// If selected Yes, now check if the patient is blocked from the TG or Facility
				if(checkPatientBlockedFromFacility(patient, getReAssignTriageGroupId()) ||
					     checkPatientBlockedFromTG(patient, getReAssignTriageGroupId())){
					setPatientBlockedTgFlag(true);
					setStationTriageGroups(getTriageGroupsByStation());
					return "select";
				}
			}

			Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
			if(getReAssignTriageGroupId()==null)
			{
				 getRequest().getSession().setAttribute(POPUPWINDOW,TRIAGEGROUP_SELECT);
				 addFieldError("triageGroupSelectError","Please select a Triage Group.");
				 setStationTriageGroups(getTriageGroupsByStation());
				 return STRUTS_RESULT;
			}

			Message updatedMessage = getMessageService().reAssignMessage(openedMessage.getId(),
																		openedMessage.getRecipientId(),
																		getReAssignTriageGroupId(),
																		null,
																		manuallyAssociate,
																		getCurrentUser(),
																		ReAssignMessageActionEnum.REASSIGN_ANOTHER_TG_WITH_IN_FACILITY).getPayload();

			if(updatedMessage==null){
				 addActionError("An Error Occured while reassigning message to Another Triage Group, please try again later.");
				 return STRUTS_ERROR;
			}

			if(!getReAssignComment().trim().equals("")){
					Annotation annotateComments = new Annotation();
					annotateComments.setAnnotation(getReAssignComment());
					annotateComments.setAuthor(getCurrentUser());
					annotateComments.setThread(updatedMessage.getThread());
					getMessageService().annotateThread(annotateComments);
					updatedMessage.getThread().getAnnotations().add(annotateComments);
			}
			getRequest().getSession().setAttribute(CURRENT_MESSAGE, updatedMessage);
			if (displayYesOrNoButtonForTG.equals("No")) {
				//cleanup
				getRequest().getSession().removeAttribute("reAssignComment");
			}
			return REFRESH_INBOX;
		}

		if(getReAssignPatientBlockedOK()!=null){
			setStationTriageGroups(getTriageGroupsByStation());
			setPatientBlockedTgFlag(false);
			return "select";
		}

		else if(getReAssignTriageNo()!=null)
		{
			displayYesOrNoButtonForTG = "No";
			getRequest().getSession().setAttribute("displayYesOrNoButtonForTG", displayYesOrNoButtonForTG);
			setStationTriageGroups(getTriageGroupsByStation());
			getRequest().getSession().setAttribute("reAssignComment", (String)getRequest().getParameter("reAssignComment"));
		}
		else if(getReAssignTriageCancel()!=null)
		{
			getRequest().getSession().removeAttribute("reAssignComment");
			return STRUTS_CANCEL;
		}

		return STRUTS_RESULT;
	}

	public String reAssignToAnotherTriageGroupOSF(){
		String displayYesOrNoButtonForTGOSF = "Yes";
		Boolean manuallyAssociateOSF = false;
		if(getReAssignTriageOSFSubmit()!=null || getReAssignTriageOSFYes()!=null)
		{
			getRequest().getSession().removeAttribute("displayYesOrNoButtonForTGOSF");
			getRequest().getSession().setAttribute("reAssignCommentOSF", (String)getRequest().getParameter("reAssignCommentOSF"));
			String tgName = ((TriageGroup)getTriageGroupDao().findById(getReAssignTriageGroupIdOSF())).getName();
			getRequest().getSession().setAttribute("reAssignTriageGroupNameOSF",tgName);
			setReAssignTriageGroupNameOSF(tgName);
			getRequest().getSession().setAttribute("reAssignTriageGroupIdOSF",(getReAssignTriageGroupIdOSF().toString()));

			if(getReAssignTriageOSFSubmit()!=null)
			{
				// validates if the patient belongs to the selected Triage group
				Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
				Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());
				//String  stationNumber = ((Clinician)getCurrentUser()).getStationNo();
				String facStationNumber = ((Facility)getFacilityDao().findById((Long)getRequest().getSession().getAttribute("reAssignFacilityId"))).getStationNumber();

				Collection<TriageGroup> patGroup = getTriageGroupDao().getTriageGroupsForPatientByStation(patient, facStationNumber);

				//Check if the Patient belongs to the selected Triage group
				for(TriageGroup tg:patGroup){
					if(tg.getId().equals(getReAssignTriageGroupIdOSF())){
						displayYesOrNoButtonForTGOSF="No";
						break;
					}
				}
				getRequest().getSession().setAttribute("displayYesOrNoButtonForTGOSF", displayYesOrNoButtonForTGOSF);
				if (displayYesOrNoButtonForTGOSF.equals("Yes")){
					setStationTriageGroupsOSF(getTriageGroupsByStationOSF());
					return "select";
				}

				if(checkPatientBlockedFromFacility(patient, getReAssignTriageGroupIdOSF()) ||
					     checkPatientBlockedFromTG(patient, getReAssignTriageGroupIdOSF())){
					setPatientBlockedTgFlag(true);
					setStationTriageGroupsOSF(getTriageGroupsByStationOSF());
					return "select";
				}
			}
			if(getReAssignTriageOSFYes()!=null)
			{
				displayYesOrNoButtonForTGOSF="No";
				// Manually Associate the patient with this Triage Group
				manuallyAssociateOSF = true;

				Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
				Patient patient = (Patient)getUserDao().findById(openedMessage.getSenderId());

				// If selected Yes, now check if the patient is blocked from the TG or Facility
				if(checkPatientBlockedFromFacility(patient, getReAssignTriageGroupIdOSF()) ||
					     checkPatientBlockedFromTG(patient, getReAssignTriageGroupIdOSF())){
					setPatientBlockedTgFlag(true);
					setStationTriageGroupsOSF(getTriageGroupsByStationOSF());
					return "select";
				}
			}

			Message openedMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
			if(getReAssignTriageGroupIdOSF()==null)
			{
				 getRequest().getSession().setAttribute(POPUPWINDOW,TRIAGEGROUP_SELECT);
				 addFieldError("triageGroupSelectError","Please select a Triage Group.");
				 setStationTriageGroupsOSF(getTriageGroupsByStationOSF());
				 return STRUTS_RESULT;
			}
			Message updatedMessage = getMessageService().reAssignMessage(openedMessage.getId(),
																		openedMessage.getRecipientId(),
																		getReAssignTriageGroupIdOSF(),
																		null,
																		manuallyAssociateOSF,
																		getCurrentUser(),
																		ReAssignMessageActionEnum.MESSAGE_TRANSFERRED_TG_OUTSIDE_FACILITY).getPayload();
			if(updatedMessage==null){
				 addActionError("An Error Occured while reassigning message to Another Triage Group, please try again later.");
				 return STRUTS_ERROR;
			}

			if(!getReAssignCommentOSF().trim().equals("")){
					Annotation annotateComments = new Annotation();
					annotateComments.setAnnotation(getReAssignCommentOSF());
					annotateComments.setAuthor(getCurrentUser());
					annotateComments.setThread(updatedMessage.getThread());
					getMessageService().annotateThread(annotateComments);
					updatedMessage.getThread().getAnnotations().add(annotateComments);
			}
			getRequest().getSession().setAttribute(CURRENT_MESSAGE, updatedMessage);
			if (displayYesOrNoButtonForTGOSF.equals("No")) {
				//cleanup
				getRequest().getSession().removeAttribute("reAssignCommentOSF");
			}
			return REFRESH_INBOX;
		}
		else if(getReAssignTriageOSFNo()!=null)
		{
			displayYesOrNoButtonForTGOSF = "No";
			getRequest().getSession().setAttribute("displayYesOrNoButtonForTGOSF", displayYesOrNoButtonForTGOSF);
			setStationTriageGroupsOSF(getTriageGroupsByStationOSF());
			getRequest().getSession().setAttribute("reAssignCommentOSF", (String)getRequest().getParameter("reAssignCommentOSF"));
		}
		else if(getReAssignTriageOSFCancel()!=null)
		{
			getRequest().getSession().removeAttribute("reAssignCommentOSF");
			return STRUTS_CANCEL;
		}
		if(getReAssignPatientBlockedOK()!=null){
			setPatientBlockedTgFlag(false);
			setStationTriageGroupsOSF(getTriageGroupsByStationOSF());
			return "select";
		}
		return STRUTS_RESULT;
	}


	public String displayReAssignMessageHistoryTabular()
	{
		Message currentMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
		if(isClinician(getCurrentUser()) && getCurrentFolder().getName()==SystemFolderEnum.REASSIGN.getName() && currentMessage!=null){

			Collection<ReAssignMessageHistory> reAssignMessageList = getReAssignMessageService().getReAssignMessageHistoryByMessage(currentMessage.getId());
			setReAssignMessageHistoryList(reAssignMessageList);
			Patient patient = (Patient)getUserDao().findById(currentMessage.getSenderId());
			if(patient!=null){
					String nssn = patient.getNssn()!=null?patient.getNssn().substring(1,5):"";
					String dob = patient.getDob()!=null?DateUtils.getEnglishDate(patient.getDob()):"";
					setPatientSSNAndDob("[ SSN: "+nssn+", DOB: "+dob+" ]");
			}
			return STRUTS_SUCCESS;
		}else{
			return STRUTS_CANCEL;
		}
	}

	private boolean checkPatientBlockedFromTG(Patient patient, Long triageGroupId){
		// This code is removed as patient can't be blocked from SM. Patient can only be blocked from Facility or TG.
		/*
		if(patient.getStatus().equals(UserStatusEnum.BLOCKED)){
			if(log.isInfoEnabled()){
				log.info("<<<<<<<<<Reassign Message>>>>>>>Patient Blocked from System"+patient.getId());
			}
			return true;
		}
		else {
			if(log.isInfoEnabled()){
				log.info("Else Block of checkPatientBlockedFromTG...."+patient.getId()+"TgId..."+triageGroupId);
			} */
			PatientBlockedTriageGroup patBlockedTg = patientBlockedService.getPatientBlockedTriageGroupByTgIdAndPatientId(triageGroupId, patient.getId()).getPayload();
			if(patBlockedTg!=null && patBlockedTg.isBlocked()){
				if(log.isInfoEnabled()){
					log.info("<<<<<<<<<Reassign Message>>>>>>>Patient " + patient.getId() + " Blocked from Triage Group"+patBlockedTg.getId());
				}
				return true;
			}
		/*} */
		return false;
	}

	private boolean checkPatientBlockedFromFacility(Patient patient, Long triageGroupId){
		ServiceResponse<TriageGroup> triageResp = triageGroupService.findTriageGroupById(triageGroupId);
		TriageGroup tGroup = triageResp.getPayload();
		if(tGroup!=null) {
			Long stationNumber = Long.valueOf(tGroup.getVistaDiv()).longValue();

			//Also check if the facility of the triage group is blocked -
			CollectionServiceResponse<PatientBlockedFacility> collectionResponse = patientBlockedService.getBlockedFacilityPatientsByPatientIdAndStation(patient.getId(), stationNumber);
			Collection<PatientBlockedFacility> patBlockedFacilities = collectionResponse.getCollection();
			if(patBlockedFacilities!=null && patBlockedFacilities.size()>0){
				if(log.isInfoEnabled()){
					log.info("Reassign MESSAGE-> Patient " + patient.getId() + " blocked from Facility "+ stationNumber);
				}
				return true;
			}
		}
		return false;
	}



	public String getReAssignMemberCancel() {
		return reAssignMemberCancel;
	}

	public String getReAssignComment() {
		return reAssignComment;
	}

	public void setReAssignComment(String reAssignComment) {
		this.reAssignComment = reAssignComment;
	}

	public String getReAssignP2PComment() {
		return reAssignP2PComment;
	}

	public void setReAssignP2PComment(String reAssignP2PComment) {
		this.reAssignP2PComment = reAssignP2PComment;
	}

	public String getReAssignCommentOSF() {
		return reAssignCommentOSF;
	}

	public void setReAssignCommentOSF(String reAssignCommentOSF) {
		this.reAssignCommentOSF = reAssignCommentOSF;
	}

	public String getReAssignP2PCommentOSF() {
		return reAssignP2PCommentOSF;
	}

	public void setReAssignP2PCommentOSF(String reAssignP2PCommentOSF) {
		this.reAssignP2PCommentOSF = reAssignP2PCommentOSF;
	}

	public void setReAssignMemberCancel(String reAssignMemberCancel) {
		this.reAssignMemberCancel = reAssignMemberCancel;
	}

	public String getReAssignRadioSelectSubmit() {
		return reAssignRadioSelectSubmit;
	}

	public String getReAssignTriageSubmit() {
		return reAssignTriageSubmit;
	}

	public String getReAssignTriageOSFSubmit() {
		return reAssignTriageOSFSubmit;
	}

	public String getReAssignVISNSelect() {
		return reAssignVISNSelect;
	}

	public String getReAssignFacilitySelect() {
		return reAssignFacilitySelect;
	}

	public String getReAssignTriageYes() {
		return reAssignTriageYes;
	}

	public String getReAssignTriageOSFYes() {
		return reAssignTriageOSFYes;
	}

	public String getReAssignTriageNo() {
		return reAssignTriageNo;
	}

	public String getReAssignTriageOSFNo() {
		return reAssignTriageOSFNo;
	}

	public MessageService getMessageService() {
		return messageService;
	}

	public void setMessageService(MessageService messageService) {
		this.messageService = messageService;
	}

	public void setReAssignTriageSubmit(String reAssignTriageSubmit) {
		this.reAssignTriageSubmit = reAssignTriageSubmit;
	}

	public void setReAssignTriageOSFSubmit(String reAssignTriageOSFSubmit) {
		this.reAssignTriageOSFSubmit = reAssignTriageOSFSubmit;
	}

	public void setReAssignVISNSelect(String reAssignVISNSelect) {
		this.reAssignVISNSelect = reAssignVISNSelect;
	}

	public void setReAssignFacilitySelect(String reAssignFacilitySelect) {
		this.reAssignFacilitySelect = reAssignFacilitySelect;
	}

	public void setReAssignTriageYes(String reAssignTriageYes) {
		this.reAssignTriageYes = reAssignTriageYes;
	}

	public void setReAssignTriageOSFYes(String reAssignTriageOSFYes) {
		this.reAssignTriageOSFYes = reAssignTriageOSFYes;
	}

	public void setReAssignTriageNo(String reAssignTriageNo) {
		this.reAssignTriageNo = reAssignTriageNo;
	}

	public void setReAssignTriageOSFNo(String reAssignTriageOSFNo) {
		this.reAssignTriageOSFNo = reAssignTriageOSFNo;
	}

	public String getReAssignFacilityYes() {
		return reAssignFacilityYes;
	}

	public String getReAssignFacilityNo() {
		return reAssignFacilityNo;
	}

	public String getReAssignTriageCancel() {
		return reAssignTriageCancel;
	}

	public String getReAssignTriageOSFCancel() {
		return reAssignTriageOSFCancel;
	}

	public String getReAssignVISNCancel() {
		return reAssignVISNCancel;
	}

	public String getReAssignFacilityCancel() {
		return reAssignFacilityCancel;
	}

	public String getReAssignTriageGroupName() {
		return reAssignTriageGroupName;
	}

	public void setReAssignTriageGroupName(String reAssignTriageGroupName) {
		this.reAssignTriageGroupName = reAssignTriageGroupName;
	}

	public String getReAssignClinicianTriageGroupName() {
		return reAssignClinicianTriageGroupName;
	}

	public void setReAssignClinicianTriageGroupName(String reAssignClinicianTriageGroupName) {
		this.reAssignClinicianTriageGroupName = reAssignClinicianTriageGroupName;
	}

	public String getReAssignTriageGroupNameOSF() {
		return reAssignTriageGroupNameOSF;
	}

	public void setReAssignTriageGroupNameOSF(String reAssignTriageGroupNameOSF) {
		this.reAssignTriageGroupNameOSF = reAssignTriageGroupNameOSF;
	}

	public String getReAssignClinicianTriageGroupNameOSF() {
		return reAssignClinicianTriageGroupNameOSF;
	}

	public void setReAssignClinicianTriageGroupNameOSF(String reAssignClinicianTriageGroupNameOSF) {
		this.reAssignClinicianTriageGroupNameOSF = reAssignClinicianTriageGroupNameOSF;
	}

	public void setReAssignTriageCancel(String reAssignTriageCancel) {
		this.reAssignTriageCancel = reAssignTriageCancel;
	}

	public void setReAssignTriageOSFCancel(String reAssignTriageOSFCancel) {
		this.reAssignTriageOSFCancel = reAssignTriageOSFCancel;
	}

	public void setReAssignVISNCancel(String reAssignVISNCancel) {
		this.reAssignVISNCancel = reAssignVISNCancel;
	}

	public void setReAssignFacilityCancel(String reAssignFacilityCancel) {
		this.reAssignFacilityCancel = reAssignFacilityCancel;
	}

	public void setReAssignRadioSelectSubmit(String reAssignRadioSelectSubmit) {
		this.reAssignRadioSelectSubmit = reAssignRadioSelectSubmit;
	}

	public String getReAssignRadioSelectCancel() {
		return reAssignRadioSelectCancel;
	}

	public void setReAssignRadioSelectCancel(String reAssignRadioSelectCancel) {
		this.reAssignRadioSelectCancel = reAssignRadioSelectCancel;
	}

	public void setReAssignFacilityYes(String reAssignFacilityYes) {
		this.reAssignFacilityYes = reAssignFacilityYes;
	}

	public void setReAssignFacilityNo(String reAssignFacilityNo) {
		this.reAssignFacilityNo = reAssignFacilityNo;
	}

	public Collection<Facility> getVisns() {
		return visns;
	}

	public void setVisns(Collection<Facility> visns) {
		this.visns = visns;
	}

	public Collection<Facility> getFacilities() {
		return facilities;
	}

	public void setFacilities(Collection<Facility> facilities) {
		this.facilities = facilities;
	}

	public Collection<TriageGroup> getStationTriageGroups() {
		return stationTriageGroups;
	}

	public void setStationTriageGroups(Collection<TriageGroup> stationTriageGroups) {
		this.stationTriageGroups = stationTriageGroups;
	}

	public Collection<TriageGroup> getClinicianTriageGroups() {
		return clinicianTriageGroups;
	}

	public void setClinicianTriageGroups(Collection<TriageGroup> clinicianTriageGroups) {
		this.clinicianTriageGroups = clinicianTriageGroups;
	}

	public Collection<TriageGroup> getStationTriageGroupsOSF() {
		return stationTriageGroupsOSF;
	}

	public void setStationTriageGroupsOSF(Collection<TriageGroup> stationTriageGroupsOSF) {
		this.stationTriageGroupsOSF = stationTriageGroupsOSF;
	}

	public Collection<TriageGroup> getClinicianTriageGroupsOSF() {
		return clinicianTriageGroupsOSF;
	}

	public void setClinicianTriageGroupsOSF(Collection<TriageGroup> clinicianTriageGroupsOSF) {
		this.clinicianTriageGroupsOSF = clinicianTriageGroupsOSF;
	}

	public String getPatientSSNAndDob() {
		return patientSSNAndDob;
	}

	public void setPatientSSNAndDob(String patientSSNAndDob) {
		this.patientSSNAndDob = patientSSNAndDob;
	}

	public String getReAssignMemberSubmit() {
		return reAssignMemberSubmit;
	}

	public void setReAssignMemberSubmit(String reAssignMemberSubmit) {
		this.reAssignMemberSubmit = reAssignMemberSubmit;
	}

	public String getSurrogateName() {
		return surrogateName;
	}

	public void setSurrogateName(String surrogateName) {
		this.surrogateName = surrogateName;
	}

	public Long getClinicianId() {
		return clinicianId;
	}

	public void setClinicianId(Long clinicianId) {
		this.clinicianId = clinicianId;
	}

	public Long getReAssignTriageGroupId() {
		return reAssignTriageGroupId;
	}

	public void setReAssignTriageGroupId(Long reAssignTriageGroupId) {
		this.reAssignTriageGroupId = reAssignTriageGroupId;
	}

	public Long getReAssignClinicianTriageGroupId() {
		return reAssignClinicianTriageGroupId;
	}

	public void setReAssignClinicianTriageGroupId(Long reAssignClinicianTriageGroupId) {
		this.reAssignClinicianTriageGroupId = reAssignClinicianTriageGroupId;
	}

	public Long getReAssignTriageGroupIdOSF() {
		return reAssignTriageGroupIdOSF;
	}

	public void setReAssignTriageGroupIdOSF(Long reAssignTriageGroupIdOSF) {
		this.reAssignTriageGroupIdOSF = reAssignTriageGroupIdOSF;
	}

	public Long getReAssignClinicianTriageGroupIdOSF() {
		return reAssignClinicianTriageGroupIdOSF;
	}

	public void setReAssignClinicianTriageGroupIdOSF(Long reAssignClinicianTriageGroupIdOSF) {
		this.reAssignClinicianTriageGroupIdOSF = reAssignClinicianTriageGroupIdOSF;
	}

	public Long getReAssignVISNId() {
		return reAssignVISNId;
	}

	public void setReAssignVISNId(Long reAssignVISNId) {
		this.reAssignVISNId = reAssignVISNId;
	}

	public Long getReAssignFacilityId() {
		return reAssignFacilityId;
	}

	public void setReAssignFacilityId(Long reAssignFacilityId) {
		this.reAssignFacilityId = reAssignFacilityId;
	}

	public void setReAssignMessageHistoryList(
			Collection<ReAssignMessageHistory> reAssignMessageHistoryList) {
		this.reAssignMessageHistoryList = reAssignMessageHistoryList;
	}

	public Collection<ReAssignMessageHistory> getReAssignMessageHistoryList() {
			return reAssignMessageHistoryList;
	}


	public boolean isPatientBlockedTgFlag() {
		return patientBlockedTgFlag;
	}

	public void setPatientBlockedTgFlag(boolean patientBlockedTgFlag) {
		this.patientBlockedTgFlag = patientBlockedTgFlag;
	}

	public String getReAssignPatientBlockedOK() {
		return reAssignPatientBlockedOK;
	}

	public void setReAssignPatientBlockedOK(String reAssignPatientBlockedOK) {
		this.reAssignPatientBlockedOK = reAssignPatientBlockedOK;
	}

	public String getReAssignOptionGroup() {
		return reAssignOptionGroup;
	}

	public void setReAssignOptionGroup(String reAssignOptionGroup) {
		this.reAssignOptionGroup = reAssignOptionGroup;
	}

}
